/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.skloch.game.HustleGame;
import com.skloch.game.scoring.Achievement;
import com.skloch.game.screens.GameOverScreen;

public class AchievementScreen
implements Screen {
    private HustleGame game;
    private Stage achievementStage;
    private OrthographicCamera camera;
    private Viewport viewport;

    public AchievementScreen(final HustleGame game) {
        this.game = game;
        this.achievementStage = new Stage(new FitViewport(game.width, game.height));
        Gdx.input.setInputProcessor(this.achievementStage);
        this.camera = new OrthographicCamera();
        this.viewport = new FitViewport(game.width, (float)game.height, this.camera);
        this.camera.setToOrtho(false, game.width, game.height);
        Window achievementMenu = new Window("", game.skin);
        this.achievementStage.addActor(achievementMenu);
        achievementMenu.setModal(true);
        Table achievementTable = new Table();
        achievementMenu.add(achievementTable).prefHeight(600.0f);
        Label title = new Label("Achievements", game.skin, "button");
        achievementTable.add(title).padTop(10.0f);
        achievementTable.row();
        Table scrollTable = new Table();
        ScrollPane scrollWindow = new ScrollPane((Actor)scrollTable, game.skin);
        scrollWindow.setFadeScrollBars(false);
        achievementTable.add(scrollWindow).padTop(20.0f).height(350.0f);
        achievementTable.row();
        Label text = new Label(Achievement.getInstance().getUserAchievements(), game.skin, "interaction");
        text.setWrap(true);
        scrollTable.add(text).width(520.0f).padLeft(15.0f);
        TextButton exitButton = new TextButton("Back", game.skin);
        achievementTable.add(exitButton).bottom().width(300.0f).padTop(10.0f);
        achievementMenu.pack();
        achievementMenu.setSize(600.0f, 600.0f);
        achievementMenu.setX(this.viewport.getWorldWidth() / 2.0f - achievementMenu.getWidth() / 2.0f);
        achievementMenu.setY(this.viewport.getWorldHeight() / 2.0f - achievementMenu.getHeight() / 2.0f);
        exitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.soundManager.playButton();
                AchievementScreen.this.dispose();
                game.setScreen(new GameOverScreen(game));
            }
        });
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.game.blueBackground.draw();
        this.achievementStage.act(delta);
        this.achievementStage.draw();
        this.camera.update();
    }

    @Override
    public void resize(int width, int height) {
        this.achievementStage.getViewport().update(width, height);
        this.viewport.update(width, height);
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }
}

